﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja Z-7</title>
		<script runat="server">

	class Total {
		readonly Pracownik pracownik;
		readonly FromTo okres;
		readonly int norma;
		readonly int praca;
		decimal wynagrodzenie;
		
		public Total(Pracownik pracownik, FromTo okres, int norma, int praca) {
			this.pracownik = pracownik;
			this.okres = okres;
			this.norma = norma;
			this.praca = praca;
		}
		public void Add(decimal wynagrodzenie) {
			this.wynagrodzenie += wynagrodzenie;
		}
		public FromTo Okres {
			get { return okres; }
		}
		public int Rok {
			get { return okres.To.Year; }
		}
		public int Miesiąc {
			get { return okres.To.Month; }
		}
		public decimal Wynagrodzenie {
			get { return wynagrodzenie; }
		}
		public int Norma {
			get { return norma; }
		}
		public int Praca {
			get { return praca; }
		}
	}
	
	static readonly string dots = "</strong>. . . . . . . . . . . .<strong>";
	
	void Licz1Strona(Nieobecnosc nieobecność) {
		KalendModule kalend = nieobecność.Table.Module;
		Periods zas = Periods.Empty;
		Periods wynagr = Periods.Empty;
		ArrayList lista = new ArrayList();
		Hashtable ht = new Hashtable();
		Wyplata wypzas = null;
        try {
		    foreach (WypElement e in nieobecność.Elementy) {
			    if (WypElement.ZasiłekZUS.Eval(e)) {
				    zas += e.Okres;
				    wypzas = e.Wyplata;
			    }
			    else {
				    wynagr += e.Okres;
				    if (ht[e.Wyplata]==null) {
					    ht.Add(e.Wyplata, true);
					    lista.Add(e.Wyplata);
				    }
			    }
		    }
        }
        catch { Msg(); }
		
		if (wynagr==Periods.Empty) {
			WynagrOd.EditValue = dots;
			WynagrDo.EditValue = dots;
			WynagrLista.EditValue = dots + " </strong>z dnia<strong> " + dots;
		}
		else {
			WynagrOd.EditValue = wynagr.From;
			WynagrDo.EditValue = wynagr.To;
			string ss = "";
			foreach (Wyplata w in lista) {
				if (ss!="")
					ss += "</strong>,<br><strong> ";
				ss += w.Numer + " </strong>z dnia<strong> " + w.ListaPlac.Data;
			}
			WynagrLista.EditValue = ss;
		}
		
		if (zas==Periods.Empty) {
			ZasilekOd.EditValue = dots;
			ZasilekDo.EditValue = dots;
			ZasilekLista.EditValue = dots;
			ZasilekData.EditValue = dots;
		}
		else {
			ZasilekOd.EditValue = zas.From;
			ZasilekDo.EditValue = zas.To;
			ZasilekLista.EditValue = wypzas.Numer;
			ZasilekData.EditValue = wypzas.ListaPlac.Data;
		}
		
		string zla = nieobecność.Zwolnienie.Numer;
		if (zla.Length==9)
			Zla.EditValue = "</strong>seria<strong> " + zla.Substring(0, 2) + " </strong>numer<strong> " + zla.Substring(2, 7);
		else if (zla!="")
			Zla.EditValue = "</strong>numer<strong> " + zla;
		else
			Zla.EditValue = "</strong>seria<strong> " + dots + " </strong>numer<strong> " + dots;
			
		FromTo okres = FromTo.Empty;
		INieobecnosc n = nieobecność;
		while ((n=Poprzednia(n))!=null && n.Definicja.Przyczyna==nieobecność.Definicja.Przyczyna)
			if (okres==FromTo.Empty)
				okres = n.Okres;
			else
				okres = okres.OuterAdd(n.Okres);
		if (okres==FromTo.Empty) {
			PoprzedniaOd.EditValue = dots;
			PoprzedniaDo.EditValue = dots;
		}
		else {
			PoprzedniaOd.EditValue = okres.From;
			PoprzedniaDo.EditValue = okres.To;
		}
	}
	
	INieobecnosc Poprzednia(INieobecnosc n) {
		KalkulatorPracy kalk = new KalkulatorPracy(n.Pracownik);
		n = kalk.Nieobecnosc(n.Okres.From-1);
		return n;
	}
	
    void OnContextLoad(Object sender, EventArgs args) {		
        report = ReportHeader1;
		Nieobecnosc nieobecność = (Nieobecnosc)dc[typeof(Nieobecnosc)];
		
		Licz1Strona(nieobecność);
		
		Pracownik pracownik = nieobecność.Pracownik;
		FromTo okres = nieobecność.Okres;
		int mies = pracownik[okres.From].Nieobecnosci.PodstawaZasilku;
		YearMonth to = new YearMonth(okres.From)-1;
		YearMonth from = to - mies + 1;
		okres = new FromTo(from.FirstDay, to.LastDay);
		okres *= pracownik[okres.From].Etat.OkresZatrudnienia;
		Periods okresy = Periods.New(okres);
		okresy = okresy.BreakByMonth();
	
		ArrayList totals = new ArrayList();
		foreach (FromTo ft in okresy) {
            int norma = pracownik.Czasy.Norma(ft).Dni
                - pracownik.Czasy.KalkPracy.NormaNie(ft, Nieobecnosc.Nieusprawiedliwiona).Dni;
            
            int praca = pracownik.Czasy.Praca(ft, Dzien.Pracy, AlgorytmyPłacowe.OR, Dzien.Zestawienie).Dni
                + pracownik.Czasy.KalkPracy.NormaNie(ft, Nieobecnosc.UsprawiedliwionaPłatna).Dni;
            
			totals.Add(new Total(pracownik, ft, norma, praca));
		}

		PrzyczynaNieobecnosci przyczyna = nieobecność.Definicja.Przyczyna;
        try {
		    foreach (WypElement e in pracownik.Elementy[okres])
			    if (e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ!=TypPodstawyZasilku.NieWliczać) {
				    bool ok;
				    switch (przyczyna) {
				    case PrzyczynaNieobecnosci.UrlopMacierzyński:
					    ok = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Macierzynskich; break;
				    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
					    ok = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Rehabilitacyjnych; break;
				    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
					    ok = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Opiekunczych; break;
				    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
					    ok = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Chorobowych; break;
				    default:
					    ok = false; break;
				    }
				    if (ok)
					    foreach (Total t in totals)
						    if (t.Okres.Contains(e.Okres.To)) {
							    t.Add(e.Wartosc);
							    break;
						    }
			    }
        }
        catch { Msg(); }
					
		Grid1.DataSource = totals;
		Grid2.DataSource = new object[] { 1, 1 };
	}
	
	public static void Msg(object obj) {
	}
	
    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="DeklaracjaZ7" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kalend.Nieobecnosc,Soneta.KadryPlace"></ea:datacontext><cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="ZASTĘPCZA ASYGNATA ZASIŁKOWA" runat="server"></cc1:reportheader>
			<P>Stwierdza się, że
				<ea:datalabel id="DataLabel1" runat="server" DataMember="Pracownik.Last.Plec"
					Bold="False">
					<VALUESMAP>
						<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				<ea:datalabel id="DataLabel5" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:datalabel>
				<ea:datalabel id="DataLabel6" runat="server" DataMember="Pracownik.Last.Plec" Bold="False">
					<VALUESMAP>
						<ea:ValuesPair Key="Kobieta" Value="zamieszkała"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="zamieszkały"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				<ea:datalabel id="DataLabel2" runat="server" DataMember="Pracownik.Adres.Linia1"></ea:datalabel>,&nbsp;
				<ea:datalabel id="Datalabel7" runat="server" DataMember="Pracownik.Adres.Linia2"></ea:datalabel>,</P>
			<P>PESEL:
				<ea:datalabel id="DataLabel3" runat="server" DataMember="Pracownik.Last.PESEL"></ea:datalabel>,&nbsp;NIP:
				<ea:datalabel id="DataLabel4" runat="server" DataMember="Pracownik.Last.NIP"></ea:datalabel>,</P>
			<P>
				ma prawo do
				<ea:datalabel id="Datalabel8" runat="server" DataMember="Definicja.Przyczyna">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				&nbsp;*)</P>
			<P>- dalszego zasiłku za okres od
				<ea:datalabel id="PoprzedniaOd" runat="server"></ea:datalabel>&nbsp;do
				<ea:datalabel id="PoprzedniaDo" runat="server"></ea:datalabel>.
			</P>
			<P>
				Zaświadczenie o czasowej niezdolności do pracy
				<ea:datalabel id="Zla" runat="server"></ea:datalabel>,</P>
			<P>objemuje okres od
				<ea:datalabel id="Datalabel9" runat="server" DataMember="Okres.From">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				&nbsp;do
				<ea:datalabel id="Datalabel10" runat="server" DataMember="Okres.To">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>.
			</P>
			<P>Z okresu orzeczonego w powołanym zaświadczeniu wypłacono wynagrodzenie
			</P>
			<P>
				za okres od
				<ea:datalabel id="WynagrOd" runat="server">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;do
				<ea:datalabel id="WynagrDo" runat="server">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;</P>
			<P>wg listy płatniczej nr
				<ea:datalabel id="WynagrLista" runat="server"></ea:datalabel>
				.
			</P>
			<P>-------------------------------------------------------------------------------------------------------------</P>
			<P>
				<ea:datalabel id="Datalabel11" runat="server" DataMember="Definicja.Przyczyna">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="Zasiłek macierzyński"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="Zasiłek opiekuńczy"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="Świadczenie rehebilitacyjne"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="Zasiłek chorobowy"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;*) za okres od
				<ea:datalabel id="ZasilekOd" runat="server"></ea:datalabel>
				&nbsp;do
				<ea:datalabel id="ZasilekDo" runat="server"></ea:datalabel>,</P>
			<P>na podstawie . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
				. . . . . . . . . . . . . . . .
			</P>
			<P>
				Ostatniej wyplaty dokonano na liście płatniczej nr
				<ea:datalabel id="ZasilekLista" runat="server"></ea:datalabel>&nbsp;z dnia
				<ea:datalabel id="ZasilekData" runat="server"></ea:datalabel>
				.
			</P>
			<P>-------------------------------------------------------------------------------------------------------------</P>
			<P>*) Wymienić rodzaj zasiłku</P>
			<UL>
				<LI>
				chorobowy
				<LI>
				opiekuńczy
				<LI>
				macierzyński lub w wysokości zasiłku macierzyńskiego
				<LI>
					świadczenie rehabilitacyjne</LI></UL>
			<P><ea:pagebreak id="PageBreak1" runat="server"></ea:pagebreak></P>
			<H3 align="center">OBLICZENIE ZASIŁKU</H3>
			<p align="center"><ea:grid id="Grid1" runat="server"><COLUMNS>
						<ea:GridColumn DataMember="Rok" Width="10" Align="Center"></ea:GridColumn>
						<ea:GridColumn DataMember="Miesiąc" Width="10" Align="Center"></ea:GridColumn>
						<ea:GridColumn DataMember="Praca" Width="20" Align="Center" Caption="Liczba dni, które ww.~Przepracował(a)"></ea:GridColumn>
						<ea:GridColumn DataMember="Norma" Width="20" Align="Center" Caption="Liczba dni, które ww.~Był(a) obowiązany(a) przepracować"></ea:GridColumn>
						<ea:GridColumn DataMember="Wynagrodzenie" Width="20" Align="Right" Caption="Wynagrodzenie" Format="{0:n}"></ea:GridColumn>
					</COLUMNS>
				</ea:grid></p>
			<P>
				<TABLE id="Table1" cellSpacing="0" width="100%">
					<TR>
						<TD width="50%">
							<P align="center">. . . . . . . . . . . . . . . . . . . .
								<BR>
								<FONT size="2">(pieczęć pracodawcy)</FONT></P>
						</TD>
						<TD>
							<P align="center">. . . . . . . . . . . . . . . . . . . .<BR>
								<FONT size="2">(data podpis i pieczęć upoważnionego pracownika)</FONT></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P><ea:grid id="Grid2" runat="server"><COLUMNS>
						<ea:GridColumn DataMember="#" Width="4" Align="Right" Caption="Lp."></ea:GridColumn>
						<ea:GridColumn Caption="Lista wypłat~Nr" Format=" "></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Lista wypłat~z dnia"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Lista wypłat~poz." RightBorder="Double"></ea:GridColumn>
						<ea:GridColumn Caption="Rodzaj zasiłku" RightBorder="Double"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Stawka %" RightBorder="Double"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~od"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~do"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~liczba dni" RightBorder="Double" Total="Info"></ea:GridColumn>
						<ea:GridColumn Caption="Do wypłaty" Total="Sum"></ea:GridColumn>
					</COLUMNS>
				</ea:grid></P>
			<P>
				<TABLE id="Table2" cellSpacing="0" width="100%">
					<TR>
						<TD width="50%">
							<P align="center">Obliczył . . . . . . . . . . . . . . . . . . . .
								<BR>
							</P>
						</TD>
						<TD>
							<P align="center">Sprawdził . . . . . . . . . . . . . . . . . . . .<BR>
								<FONT size="2">(pieczęć "wypłacono")</FONT></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter></form>
	</body>
</HTML>
